/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.gui.screen;

import com.alexander.mutantmore.entities.Rodling;
import com.alexander.mutantmore.network.Messages;
import com.alexander.mutantmore.network.SyncRodlingCheckerUpdatesToServerPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RodlingCheckerScreen
extends Screen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("mutantmore", "textures/gui/rodling_checker.png");
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    public boolean burnBlocks;
    public boolean alwaysShowName;
    private float xMouse;
    private float yMouse;
    public Rodling rodling;

    public RodlingCheckerScreen(Rodling rodling) {
        super(rodling.m_5446_());
        this.f_96541_ = Minecraft.m_91087_();
        this.rodling = rodling;
        this.f_96547_ = this.f_96541_.f_91062_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.burnBlocks = this.rodling.burnsBlocks();
        this.alwaysShowName = this.rodling.alwaysShowsName();
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        this.m_142416_((GuiEventListener)new Button(i + 18, j + 100, 140, 20, this.burnBlocksTextComponent(), button -> {
            this.burnBlocks = !this.burnBlocks;
            Messages.sendToServer(new SyncRodlingCheckerUpdatesToServerPacket(this.rodling, this.burnBlocks, this.alwaysShowName));
            button.m_93666_(this.burnBlocksTextComponent());
        }));
        this.m_142416_((GuiEventListener)new Button(i + 18, j + 130, 140, 20, this.alwaysShowNameTextComponent(), button -> {
            this.alwaysShowName = !this.alwaysShowName;
            Messages.sendToServer(new SyncRodlingCheckerUpdatesToServerPacket(this.rodling, this.burnBlocks, this.alwaysShowName));
            button.m_93666_(this.alwaysShowNameTextComponent());
        }));
    }

    public Component burnBlocksTextComponent() {
        return Component.m_237115_((String)"gui.mutantmore.rodling_checker.burn_blocks").m_130946_(": ").m_130946_(I18n.m_118938_((String)(this.burnBlocks ? "options.on" : "options.off"), (Object[])new Object[0]));
    }

    public Component alwaysShowNameTextComponent() {
        return Component.m_237115_((String)"gui.mutantmore.rodling_checker.always_show_name").m_130946_(": ").m_130946_(I18n.m_118938_((String)(this.alwaysShowName ? "options.on" : "options.off"), (Object[])new Object[0]));
    }

    public void m_86600_() {
        if (!this.rodling.m_6084_()) {
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    public void m_6305_(PoseStack p_98791_, int p_98792_, int p_98793_, float p_98794_) {
        this.xMouse = p_98792_;
        this.yMouse = p_98793_;
        this.m_7333_(p_98791_);
        this.renderBg(p_98791_, p_98794_, p_98792_, p_98793_);
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        this.f_96547_.m_92889_(p_98791_, this.m_96636_(), (float)(i + 15), (float)(j + 5), 0x404040);
        StringBuilder healthStringBuilder = new StringBuilder();
        healthStringBuilder.append(": ").append(this.rodling.m_21223_()).append("/").append(this.rodling.m_21233_());
        RodlingCheckerScreen.m_93215_((PoseStack)p_98791_, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.mutantmore.rodling_checker.health").m_130946_(healthStringBuilder.toString()), (int)(i + 114), (int)(j + 44), (int)0xFFFFFF);
        RodlingCheckerScreen.m_93215_((PoseStack)p_98791_, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.mutantmore.rodling_checker.armoured").m_130946_(": ").m_130946_(I18n.m_118938_((String)(this.rodling.isArmoured() ? "gui.yes" : "gui.no"), (Object[])new Object[0])), (int)(i + 114), (int)(j + 59), (int)0xFFFFFF);
        RodlingCheckerScreen.m_93215_((PoseStack)p_98791_, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.mutantmore.rodling_checker.shielded").m_130946_(": ").m_130946_(I18n.m_118938_((String)(this.rodling.hasShields() ? "gui.yes" : "gui.no"), (Object[])new Object[0])), (int)(i + 114), (int)(j + 74), (int)0xFFFFFF);
        super.m_6305_(p_98791_, p_98792_, p_98793_, p_98794_);
    }

    protected void renderBg(PoseStack p_98786_, float p_98787_, int p_98788_, int p_98789_) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        this.m_93228_(p_98786_, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int health = (int)(this.rodling.m_21223_() * 150.0f / this.rodling.m_21233_());
        this.m_93228_(p_98786_, i + 13, j + 24, 0, 167, health, 6);
        InventoryScreen.m_98850_((int)(i + 43), (int)(j + 83), (int)50, (float)((float)(i + 43) - this.xMouse), (float)((float)(j + 73) - this.yMouse), (LivingEntity)this.rodling);
    }

    public boolean m_7043_() {
        return false;
    }
}

